/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Arrays;
import java.util.Vector;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskUSMDriverChecks {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static final int OPT_INSTALLED = 0;
    private static final int OPT_LOADED = 1;
    private static final String STR_OPT_INSTALLED = "installed";
    private static final String STR_OPT_LOADED = "loaded";
    private static final String[] m_strCmdOption = new String[]{"installed", "loaded"};
    private static final String STR_TRUE = "true";

    private boolean runDriverCommand(String[] nodeList, ResultSet resultSet, int cmdOption) {
        Trace.out((int)2, (String)"Entry");
        boolean ret = false;
        VerificationCommand[] driverCmdArray = new VerificationCommand[nodeList.length];
        Trace.out((int)5, (String)("Node List to runDriverCommand " + Arrays.asList(nodeList)));
        String stateCmd = VerificationUtil.getUSMDriverStatePath();
        for (int j = 0; j < nodeList.length; ++j) {
            String[] arg = new String[]{"-rungencmd", stateCmd, m_strCmdOption[cmdOption]};
            Trace.out((int)5, (String)("Driver command args: " + Arrays.asList(arg)));
            String[] env = null;
            driverCmdArray[j] = new VerificationCommand(nodeList[j], arg, env);
        }
        new GlobalHandler().submit((Command[])driverCmdArray, 0, resultSet);
        if (!resultSet.anySuccess()) {
            Trace.out((int)5, (String)("Global failure executing driver command " + m_strCmdOption[cmdOption]));
            String message = s_msgBundle.getMessage("5177", false, (Object[])new String[]{m_strCmdOption[cmdOption]});
            ErrorDescription errorDesc = new ErrorDescription(message);
            resultSet.addErrorDescription(nodeList, errorDesc);
            ReportUtil.printError(message);
            return false;
        }
        block4: for (int nodeIndex = 0; nodeIndex < nodeList.length; ++nodeIndex) {
            VerificationCommand driverCmd = driverCmdArray[nodeIndex];
            Result result = driverCmd.getResult();
            if (result.getStatus() != 1) continue;
            String node = driverCmd.getNode();
            String output = driverCmd.getOutput();
            result.addResultInfo(output);
            result.addCommandInfo(driverCmd.getExecCommand());
            Trace.out((int)5, (String)("Output from driver command " + m_strCmdOption[cmdOption] + " is =" + output));
            switch (cmdOption) {
                case 0: 
                case 1: {
                    if (output.contains(STR_TRUE)) continue block4;
                    result.setStatus(3);
                    continue block4;
                }
                default: {
                    result.setStatus(3);
                }
            }
        }
        return true;
    }

    public boolean checkDriversInstalled(String[] nodeList, ResultSet resultSet) {
        Trace.out((int)2, (String)"Entry");
        return this.runDriverCommand(nodeList, resultSet, 0);
    }

    public boolean checkDriversLoaded(Vector<String> nodeVect, ResultSet resultSet) {
        Trace.out((int)2, (String)"Entry");
        return this.runDriverCommand(nodeVect.toArray(new String[nodeVect.size()]), resultSet, 1);
    }
}

